IF (EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME ='ENVIAR_ECOMMERCE' AND OBJECT_ID=OBJECT_ID('TELE_ETAPA_VALIDACAO'))
	AND EXISTS (SELECT 1 FROM SYS.COLUMNS WHERE NAME ='DS_ETAPA_VALIDACAO_ENUM' AND OBJECT_ID=OBJECT_ID('TELE_ETAPA_VALIDACAO')))
BEGIN

	DECLARE @AtualizacaoRegistros AS TABLE (
	CD_ETAPA_VALIDACAO INT,
	DS_ETAPA_VALIDACAO_ENUM VARCHAR(255) NULL,
	ENVIAR_ECOMMERCE INT
	)

	INSERT INTO @AtualizacaoRegistros
	VALUES 
	(1,'AGUARD_SEPARACAO',1)
	,(2,'EM_CHECKOUT',0)
	,(3,'AGUARD_CONF',0)
	,(4,'CONFERIDO',1)
	,(5,'SAIDA',1)
	,(6,'ENTREGUE',0)
	,(7,'CANCELADO',1)
	,(8,'ALTERACAO',0)
	,(9,'RESOL_PENDENCIA',0)
	,(10,'PENDENCIA_RESOL',0)
	,(11,'PENDENCIA',0)
	,(12,'RETORNO',1)
	,(13,'DEVOLUCAO',0)
	,(14,'EMITINDO_CUPOM_FISCAL',0)
	,(15,'PEDIDO_PESQUISA',0)
	,(16,'EM_SEPARACAO',0)
	,(17,'AGUARD_CONF_BALCAO',0)
	,(18,NULL,0)
	,(19,'AGUARD_ENTREGUE',1)
	,(20,NULL,0)
	,(21,'AGUARD_RECEBIMENTO',1)
	,(22,'AGUARDANDO_PRODUTO',0)
	,(23,'ALTERADO_ATENDIMENTO_PARCIAL',0)
	,(24,'PEDIDO_ABANDONADO',0)
	,(25,'AGUARD_FATURAMENTO_EXTERNO',1)


	UPDATE T
	SET DS_ETAPA_VALIDACAO_ENUM = A.DS_ETAPA_VALIDACAO_ENUM,
		ENVIAR_ECOMMERCE = A.ENVIAR_ECOMMERCE
	FROM TELE_ETAPA_VALIDACAO T
	INNER JOIN @AtualizacaoRegistros A ON A.CD_ETAPA_VALIDACAO = T.CD_ETAPA_VALIDACAO

END
